<?php
/**
 * Main Group endpoints.
 *
 * @package Nisje
 */

defined( 'ABSPATH' ) || die( 'Shame on you' );

// The users main group.
register_rest_field( 'user', 'main_group', [
	'get_callback' => function( $object ) {
		return nisje_get_main_group( $object['id'] );
	},
	'schema'       => [
		'context'     => [ 'view', 'edit' ],
		'description' => esc_html__( 'The users main group.', 'nisje' ),
		'type'        => 'integer',
		'readonly'    => true,
	],
] );
