<?php
/**
 * Plugin Name: Nisje - Mandatory Groups
 * Description: Feature to allow setting mandatory groups users are automatically subscribed to. The users will join the mandatory groups through a filter when logging in.
 * Author:      Dekode
 * Author URI:  https://dekode.no/en/
 * Version:     7.2.0
 * Text Domain: nisje-mandatory-groups
 * Domain Path: /languages/
 * License:     GPLv2 or later (license.txt)
 *
 * @package Nisje
 */

declare( strict_types = 1 );

defined( 'ABSPATH' ) || die( 'Shame on you' );

define( 'NISJE_MANDATORY_GROUPS_VERSION', '7.2.0' );

/**
 * Load plugin textdomain.
 */
function nisje_mandatory_groups_load_textdomain() {
	load_plugin_textdomain( 'nisje-mandatory-groups', false, basename( __DIR__ ) . '/languages' );
}
add_action( 'plugins_loaded', 'nisje_mandatory_groups_load_textdomain' );

/**
 * Include plugin components
 */
function nisje_mandatory_groups_include() {
	require __DIR__ . '/mandatory-groups/mandatory-groups.php';
}
add_action( 'nisje_include', 'nisje_mandatory_groups_include' );
