# Nisje: Mandatory Groups

## Overview

Feature to allow setting mandatory groups users are automatically subscribed to. The users will join the mandatory groups through a filter when logging in.

## Table of Contents
- [Git flow and releases](#git-flow-and-releases)

## Git flow and releases
This project uses `git-flow` as a release strategy. Check out https://nvie.com/posts/a-successful-git-branching-model/

Doing a release:
```bash
# Release branches are created from the develop branch
$ git checkout -b release-x.x.x develop

# Bump version and commit the change
$ git commit -am "Bumped version number to x.x.x"

# Checkout the master branch
$ git checkout master

# Merge in the release branch
$ git merge release-x.x.x

# Tag the release
$ git tag -a x.x.x -m "Releasing version x.x.x"

# Checkout the develop branch
$ git checkout develop

# Merge in the release branch
$ git merge release-x.x.x

# Delete the release branch
$ git branch -d release-x.x.x
```
