<?php
/**
 * Setup Mandatory Group Settings.
 *
 * @package Nisje
 */

declare( strict_types = 1 );

defined( 'ABSPATH' ) || die( 'Shame on you' );

$field_key_prefix = nisje_get_setting( 'field_key_prefix', 'mandatory_groups' );

acf_add_local_field_group(
	[
		'key'                   => $field_key_prefix . '_mandatory_groups',
		'title'                 => 'Mandatory Groups',
		'fields'                => [
			[
				'key'          => $field_key_prefix . '_groups',
				'label'        => 'Add groups',
				'name'         => $field_key_prefix . '_groups',
				'type'         => 'repeater',
				'layout'       => 'row',
				'button_label' => 'Add new group',
				'sub_fields'   => [
					[
						'key'   => $field_key_prefix . '_group',
						'label' => 'Group',
						'name'  => 'group',
						'type'  => 'bp_groups',
					],
				],
			],
		],
		'location'              => [
			[
				[
					'param'    => 'options_page',
					'operator' => '==',
					'value'    => nisje_get_setting( 'settings_menu_key', 'mandatory_groups' ),
				],
			],
		],
		'menu_order'            => 0,
		'position'              => 'normal',
		'style'                 => 'default',
		'label_placement'       => 'top',
		'instruction_placement' => 'label',
		'hide_on_screen'        => '',
		'active'                => 1,
		'description'           => '',
	]
);
