<?php
/**
 * Extend User with Title and Leader.
 *
 * @package Nisje
 */

declare( strict_types = 1 );
defined( 'ABSPATH' ) || die( 'Shame on you' );

// Registration data.
register_rest_field(
	'user', 'title', [
		'get_callback'    => function( $object ) {
			return get_user_meta( $object['id'], 'nisje_nb_title', true );
		},
		'update_callback' => function( $value, $object ) {
			update_user_meta( $object->ID, 'nisje_nb_title', $value );
		},
		'schema'          => [
			'context'     => [ 'view', 'edit' ],
			'description' => esc_html__( 'User title', 'nisje-nb' ),
			'type'        => 'string',
		],
	]
);

// Add newsletter consent to user.
register_rest_field(
	'user', 'newsletter_consent', [
		'get_callback'    => function( $object ) {
			return (bool) get_user_meta( $object['id'], 'nisje_nb_newsletter_consent', true );
		},
		'update_callback' => function( $value, $object, $field_name, $request, $object_type ) {
			update_user_meta( $object->ID, 'nisje_nb_newsletter_consent', (bool) $value );
		},
		'schema'          => [
			'context'     => [ 'view', 'edit' ],
			'description' => esc_html__( 'Add newsletter consent', 'nisje-nb' ),
			'type'        => 'boolean',
		],
	]
);

// Registration data.
register_rest_field(
	'user', 'library_leader', [
		'get_callback'    => function( $object ) {
			return (bool) get_user_meta( $object['id'], 'nisje_nb_library_leader', true );
		},
		'update_callback' => function( $value, $object, $field_name, $request, $object_type ) {
			$library_leader_group = (int) $request->get_param( 'library_leader_group_id' );

			update_user_meta( $object->ID, 'nisje_nb_library_leader', (bool) $value );
			update_user_meta( $object->ID, 'nisje_nb_library_leader_groups', [ $library_leader_group ] );
		},
		'schema'          => [
			'context'     => [ 'view', 'edit' ],
			'description' => esc_html__( 'Is this user the leader of a library', 'nisje-nb' ),
			'type'        => 'boolean',
		],
	]
);

// User libraries.
register_rest_field(
	'user', 'libraries', [
		'get_callback' => function( $object ) {
			$groups = groups_get_groups( [
				'user_id'    => $object['id'],
				'group_type' => 'library',
			] );

			$retval = [];

			foreach ( $groups['groups'] as $group ) {
				$retval[] = $group->id;
			}

			return $retval;
		},
		'schema'       => [
			'context'     => [ 'view', 'edit' ],
			'description' => esc_html__( 'Users libraries', 'nisje-nb' ),
			'type'        => 'array',
		],
	]
);
