<?php
/**
 * Synkron CLI class.
 *
 * @package Nisje
 */

declare( strict_types=1 );

namespace Dekode\Nisje\Commands;

use WP_CLI;
use Exception;
use StdClass;
use WP_Post;

if ( class_exists( 'WP_CLI' ) ) {
	/**
	 * Synkron functionality
	 */
	class NB_Synkron {
		/**
		 * This function is run on the command "wp nb-synkron export_ephorte"
		 */
		public function export_ephorte() {
			$query_args = [
				'post_type'      => nisje_get_setting( 'post_type_name', 'nb_applications' ),
				'posts_per_page' => -1,
				'post_status'    => 'delivered',
				'meta_key'       => 'nb_ephorte_ready', // phpcs:ignore
				'meta_value'     => '1', // phpcs:ignore
			];

			$query = new \WP_Query( $query_args );

			if ( $query->have_posts() ) {
				while ( $query->have_posts() ) {
					$query->the_post();

					$delivered = (array) get_post_meta( get_the_ID(), '_nisje_nb_ephorte_delivered', true );
					if ( ! $delivered ) {
						WP_CLI::line( 'Application ID ' . get_the_ID() . ' already exported' );
					} else {
						// phpcs:ignore nisje_nb_ping_synkron( get_post(), false, false, 'nb_applications' );
						$delivered[] = time();
						// phpcs:ignore update_post_meta( get_the_ID(), '_nisje_nb_ephorte_delivered', $delivered ); // phpcs:ignore
						WP_CLI::line( 'Application ID ' . get_the_ID() . ' exported' );
					}
				}
			}
		}

		/**
		 * This function is run on the command "wp nb-synkron map_users_to_newsletter"
		 */
		public function map_users_to_newsletter() {
			$wp_users             = get_users( [ 'number' => 9999 ] );
			$newsletter_users     = 0;
			$no_newsletter_users  = 0;
			$already_mapped_users = 0;

			foreach ( $wp_users as $user ) {
				$is_newsletter_user = absint( get_user_meta( $user->ID, 'nisje_nb_newsletter_consent', true ) );
				$xprofile_value     = xprofile_get_field_data( 10, $user->ID );

				if ( 'Ja' === $xprofile_value || 'Nei' === $xprofile_value ) {
					$already_mapped_users++;
				} else {
					if ( $is_newsletter_user ) {
						$newsletter_users++;
						xprofile_set_field_data( 10, $user->ID, 'Ja' );
					} else {
						$no_newsletter_users++;
						xprofile_set_field_data( 10, $user->ID, 'Nei' );
					}
				}
			}

			WP_CLI::line( $already_mapped_users . ' already mapped users.' );
			WP_CLI::line( $newsletter_users . ' newsletter users.' );
			WP_CLI::line( $no_newsletter_users . ' no newsletter users.' );
		}

		/**
		 * This function is run on the command "wp nb-synkron list_users_with_newsletter"
		 */
		public function list_users_with_newsletter() {
			$wp_users = get_users( [ 'number' => 9999 ] );
			$number   = 0;

			foreach ( $wp_users as $user ) {
				$xprofile_value = xprofile_get_field_data( 10, $user->ID );

				if ( 'Ja' === $xprofile_value ) {
					WP_CLI::line( $user->user_email . ',' . $user->display_name );
					$number++;
				}
			}

			WP_CLI::line( $number . ' number of newsletters' );
		}
	}

	$synkron = new NB_Synkron();

	WP_CLI::add_command( 'nb-synkron', $synkron );
}
