<?php
/**
 * Library functionality
 *
 * @package Nisje
 */

declare( strict_types = 1 );
namespace Dekode\Nisje\Xprofile;

defined( 'ABSPATH' ) || die( 'Shame on you' );

/**
 * Register xprofile
 */
function register_nb_xprofile_library_init() {
	require __DIR__ . '/fields/class-nb-xprofile-field-type-library-selectbox.php';

	add_filter( 'bp_xprofile_get_field_types', __NAMESPACE__ . '\\register_nb_xprofile_library_field', 10, 1 );
	add_action( 'wp_enqueue_scripts', __NAMESPACE__ . '\\enqueue_nb_xprofile_library_scripts' );
}
add_action( 'bp_include', __NAMESPACE__ . '\\register_nb_xprofile_library_init' );

/**
 * Reigster the nb library field
 *
 * @param array $fields Array of field type/class name pairings.
 */
function register_nb_xprofile_library_field( $fields ) {
	$fields['nb-library-selectbox'] = 'NB_XProfile_Field_Type_Library_Selectbox';
	return $fields;
}

/**
 * Enqueue scripts and styles
 */
function enqueue_nb_xprofile_library_scripts() {
	if ( bp_is_register_page() ) {
		wp_enqueue_style( 'select2', 'https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.5/css/select2.min.css', [], '4.0.5' );
		wp_enqueue_script( 'select2', 'https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.5/js/select2.min.js', [ 'jquery' ], '4.0.5', true );

		wp_enqueue_style( 'nb-select-library', plugins_url( 'assets/app.css', __FILE__ ), [], '1.0.0' );
		wp_enqueue_script( 'nb-select-library', plugins_url( 'assets/app.js', __FILE__ ), [ 'select2', 'jquery', 'wp-html-entities' ], '1.0.0', true );

		wp_add_inline_script(
			'nb-select-library',
			sprintf(
				'var bibToken = "%s";',
				apply_filters( 'nisje_jwt_token', false )
			),
			'before'
		);
	}
}

/**
 * Join library when user is activated
 *
 * @param int $user_id ID of the user being checked.
 */
function nb_join_library_group( $user_id ) {
	$library_id = bp_get_profile_field_data( [
		'field'   => 'Ditt bibliotek',
		'user_id' => $user_id,
	] );

	if ( ! empty( $library_id ) ) {
		groups_send_membership_request( $user_id, $library_id );
	}
}
add_action( 'bp_core_activated_user', __NAMESPACE__ . '\\nb_join_library_group', 10, 1 );
