<?php
/**
 * Filters
 *
 * @package Nisje
 */

declare( strict_types = 1 );
defined( 'ABSPATH' ) || die( 'Shame on you' );

/**
 * Disable chat
 */
add_filter( 'nisje_chat_enabled', '__return_false' );

/**
 * Change name of in the theme to not include Bibliotekutvikling
 */
add_filter( 'nisje_theme_name', function() {
	return 'Forum';
} );

/*
 * Quick fix upload issues.
 */
add_filter( 'register_post_type_args', function( $args, $post_type ) {
	if ( 'attachment' === $post_type ) {
		$args['capabilities']['edit_posts'] = 'upload_files';
	}

	return $args;
}, 10, 2 );
