<?php
/**
 * Sync Users CLI class.
 *
 * @package Nisje
 */

declare( strict_types=1 );

namespace Dekode\Nisje\Commands;

use WP_CLI;
use Exception;
use StdClass;

if ( class_exists( 'WP_CLI' ) ) {
	/**
	 * Sync functionality
	 */
	class NB_Sync_Users {
		/**
		 * This function is run on the command "wp nb-sync-users map_name"
		 */
		public function map_name() {
			WP_CLI::line( 'Start' );

			if ( function_exists( 'bp_xprofile_fullname_field_id' ) ) {
				WP_CLI::line( 'Fetch users' );
				$wp_users = get_users( [
					'number' => 5000,
					'fields' => [
						'ID',
						'display_name',
					],
				] );

				WP_CLI::line( 'Start' );

				$counter = 1;
				foreach ( $wp_users as $user ) {
					$field = xprofile_get_field_data( bp_xprofile_fullname_field_id(), $user->ID );

					if ( empty( $field ) ) {
						if ( false !== strpos( $user->display_name, ' ' ) ) {
							xprofile_set_field_data( bp_xprofile_fullname_field_id(), $user->ID, $user->display_name );
							WP_CLI::success( 'Mapped name: ' . $user->display_name );
						} else {
							WP_CLI::error( 'Name hasn\'t got a space in it. Probably a username: ' . $user->display_name, false );
						}
					} else {
						WP_CLI::error( 'Existing name: ' . $field . ' - Display name: ' . $user->display_name, false );
					}

					WP_CLI::line( $counter . ' ------------------------------' );

					$counter++;
				}
			} else {
				WP_CLI::error( 'BP not found.' );
			}
		}
	}

	$sync = new NB_Sync_Users();

	WP_CLI::add_command( 'nb-sync-users', $sync );
}
