<?php
/**
 * Plugin Name: Nisje - Nasjonalbiblioteket
 * Description: Functionality for Nasjonalbiblioteket
 * Author:      Dekode
 * Author URI:  https://dekode.no/en/
 * Version:     7.0.0
 * Text Domain: nisje-nb
 * Domain Path: /languages/
 * License:     GPLv2 or later (license.txt)
 *
 * @package Nisje
 */

declare( strict_types = 1 );
defined( 'ABSPATH' ) || die( 'Shame on you' );

define( 'NISJE_NB_VERSION', '7.0.0' );
define( 'NISJE_NB_FILES_SALT', 'hcsXTUlmZ6JiXCYc2SBgKX2gi478ki' );
define( 'NISJE_NB_PASSWORD_SALT', 'sx4eA37Id8iwxDXgsM3P3A6xrWqyOX' );

/**
 * Load plugin textdomain.
 */
function nisje_nb_load_textdomain() {
	load_plugin_textdomain( 'nisje-nb', false, basename( __DIR__ ) . '/languages' );
}
add_action( 'plugins_loaded', 'nisje_nb_load_textdomain' );

/**
 * Include plugin components
 */
function nisje_nb_include() {
	if ( ! function_exists( 'bp_is_active' ) || ! bp_is_active( 'groups' ) ) {
		return;
	}

	// Filters.
	require __DIR__ . '/filters.php';

	// Updates.
	require __DIR__ . '/updates.php';

	// Shared.
	require __DIR__ . '/shared/library-types.php';

	// Components.
	require __DIR__ . '/components/nb-library/nb-library.php';

	// WP CLI.
	if ( defined( 'WP_CLI' ) ) {
		require __DIR__ . '/wp-cli/wp-cli.php';
	}

	$current_plugin_version = NISJE_NB_VERSION;
	$version_option_key     = 'nisje_nb_version';
	$installed_version      = get_option( $version_option_key );

	// Do nothing if $installed_version is >= $plugin_version.
	if ( ! $installed_version || version_compare( $installed_version, $current_plugin_version, '<=' ) ) {
		add_action( 'init', 'nisje_nb_activation' );
	}

	add_action( 'admin_head', function() {
		remove_action( 'admin_notices', 'update_nag', 3 );
	} );
}
add_action( 'nisje_include', 'nisje_nb_include' );

/**
 * Registers scripts and styles
 */
function nisje_bibliotekutvikling_register_scripts_and_styles() {
	wp_enqueue_script( 'nisje-plugin-bibliotekutvikling' );
	wp_enqueue_style( 'nisje-plugin-bibliotekutvikling' );
}
add_action( 'wp_enqueue_scripts', 'nisje_bibliotekutvikling_register_scripts_and_styles', 20 );

// BuddyPress.
require __DIR__ . '/xprofile/register.php';
