<?php
/**
 * Extend With Type.
 *
 * @package Nisje
 */

declare( strict_types = 1 );
defined( 'ABSPATH' ) || die( 'Shame on you' );

$taxonomy_type_name = nisje_get_setting( 'taxonomy_type_name', 'nb_library' );

$endpoint = strtolower( buddypress()->groups->id );

// Types.
register_rest_field( $extend_object, 'library_type', [
	'get_callback'    => function( $object ) use ( $taxonomy_type_name ) {
		$type = '';

		$terms = get_the_terms( $object['id'], $taxonomy_type_name );
		if ( $terms ) {
			$type = $terms[0]->slug;
		}

		return $type;
	},
	'update_callback' => function( $field, $object ) use ( $taxonomy_type_name ) {
		if ( $object instanceof \WP_Post ) {
			wp_set_object_terms( $object->ID, $field, $taxonomy_type_name );
		}
	},
	'schema'          => [
		'context'     => [ 'view', 'edit' ],
		'description' => esc_html__( 'The library type', 'nisje-nb' ),
		'type'        => 'string',
	],
] );
