<?php
/**
 * Extend Groups Endpoint with Library Meta.
 *
 * @package Nisje
 */

declare( strict_types = 1 );
defined( 'ABSPATH' ) || die( 'Shame on you' );

$endpoint = strtolower( buddypress()->groups->id );

$option_key_meta       = 'nb_library_meta';
$option_key_id         = 'nb_external_ref_id';
$taxonomy_type         = nisje_get_setting( 'taxonomy_type_name', 'nb_library' );
$taxonomy_municipality = nisje_get_setting( 'taxonomy_municipality_name', 'nb_library' );

register_rest_field(
	$endpoint, 'library_meta', [
		'get_callback'    => function ( $object ) use ( $option_key_meta ) {
			$group_id = $object['id'];

			return groups_get_groupmeta( $group_id, $option_key_meta, true );
		},
		'update_callback' => function ( $value, $object ) use ( $option_key_meta, $taxonomy_type, $taxonomy_municipality ) {
			$group_id = $object->id;

			if ( isset( $value ) ) {
				return groups_update_groupmeta( $group_id, $option_key_meta, $value );
			}
		},
		'schema'          => [
			'context'     => [ 'view', 'edit', 'member' ],
			'description' => esc_html__( 'Library meta data', 'nisje-nb' ),
			'type'        => 'string',
		],
	]
);

register_rest_field(
	$endpoint, 'external_ref_id', [
		'get_callback'    => function ( $object ) use ( $option_key_id ) {
			$group_id = $object['id'];

			return groups_get_groupmeta( $group_id, $option_key_id, true );
		},
		'update_callback' => function ( $value, $object ) use ( $option_key_id ) {
			$group_id = $object->id;
			if ( isset( $value ) ) {
				return groups_update_groupmeta( $group_id, $option_key_id, $value );
			}
		},
		'schema'          => [
			'context'     => [ 'view', 'edit', 'member' ],
			'description' => esc_html__( 'Library ID', 'nisje-nb' ),
			'type'        => 'string',
		],
	]
);
