<?php
/**
 * Setup News Component
 *
 * @package Nisje
 */

namespace Dekode\Nisje\Components;

defined( 'ABSPATH' ) || die( 'Shame on you' );

/**
 * News Component Class
 */
class News extends Component {
	/**
	 * Constructor
	 */
	public function __construct() {
		$path = trailingslashit( dirname( __FILE__ ) );

		parent::start(
			'news',
			__( 'News', 'nisje-news' ),
			$path
		);
	}

	/**
	 * Global variables
	 */
	public function setup_globals() {
		$this->field_key = 'nisje_news';
		$this->key       = 'di_news';

		$defaults = [
			// Public.
			'post_type_name'                  => 'dekode-news',
			'post_type_rest_endpoint'         => 'dekode-news',
			'capability_key'                  => 'di_news', // nisje_news_cap.
			// Group.
			'post_type_name_group'            => 'nisje-news-group',
			'post_type_rest_endpoint_group'   => 'nisje-news-group',
			'capability_key_group'            => 'nisje_news_cap_group',
			// Taxonomy.
			'taxonomy_category_name'          => 'dekode-news-category',
			'taxonomy_category_rest_endpoint' => 'dekode-news-categories',
			'taxonomy_category'               => [
				'name'          => 'dekode-news-category',
				'rest_endpoint' => 'dekode-news-categories',
			],
			// General.
			'field_key'                       => $this->field_key,
			'key'                             => $this->key,
		];

		$this->settings = wp_parse_args( $this->settings, $defaults );
	}

	/**
	 * Set up the default filters
	 */
	public function setup_filters() {
		add_filter( 'nisje_feed_post_types', [ $this, 'add_feed_post_types' ] );
		add_filter( 'nisje_rest_shared_fields_group_post_types', [ $this, 'add_shared_rest_group_fields' ] );
		add_filter( 'nisje_rest_shared_fields_post_types', [ $this, 'add_shared_rest_fields' ] );
		add_filter( 'nisje_gutenberg_group_post_types', [ $this, 'add_gutenberg_group_post_types' ] );
		add_filter( 'nisje_frontend_options', [ $this, 'add_frontend_option' ] );
	}

	/**
	 * Register Content Types
	 */
	public function register_content_types() {
		$this->include_file( 'taxonomies/taxonomy-category.php' );
		$this->include_file( 'post-types/post-type-news.php' );

		if ( bp_is_active( 'groups' ) ) {
			$this->include_file( 'post-types/post-type-news-group.php' );
		}
	}

	/**
	 * Register REST Endpoints
	 */
	public function register_rest_routes() {
		$this->include_file( 'rest-handlers/extend-news.php' );
	}

	/**
	 * Add wiki settings to frontend options
	 *
	 * @param array $options Options.
	 */
	public function add_frontend_option( $options ) {
		if ( \is_user_logged_in() ) {
			$user_id = \get_current_user_id();
			$user    = \get_userdata( $user_id );

			$options['userCapabilities']['edit']['news']   = $user->allcaps['edit_di_news'] ?? false;
			$options['userCapabilities']['create']['news'] = $user->allcaps['create_di_newss'] ?? false;
		}

		return $options;
	}

	/**
	 * Add feed post types.
	 *
	 * @param array $post_types Current Post Types.
	 * @return array $post_types Populated Post Types.
	 */
	public function add_feed_post_types( $post_types ) {
		$post_types[] = nisje_get_setting( 'post_type_name_group', $this->settings_key );
		$post_types[] = nisje_get_setting( 'post_type_name', $this->settings_key );

		return $post_types;
	}

	/**
	 * Add Gutenberg group post types.
	 *
	 * @param array $post_types Current Post Types.
	 * @return array $post_types Populated Post Types.
	 */
	public function add_gutenberg_group_post_types( $post_types ) {
		$post_types[] = nisje_get_setting( 'post_type_name_group', $this->settings_key );

		return $post_types;
	}

	/**
	 * Extend rest group types.
	 *
	 * @param array $post_types Current Post Types.
	 * @return array $post_types Populated Post Types.
	 */
	public function add_shared_rest_group_fields( $post_types ) {
		$post_types[] = nisje_get_setting( 'post_type_rest_endpoint_group', $this->settings_key );

		return $post_types;
	}

	/**
	 * Extend rest post types.
	 *
	 * @param array $post_types Current Post Types.
	 * @return array $post_types Populated Post Types.
	 */
	public function add_shared_rest_fields( $post_types ) {
		$post_types[] = nisje_get_setting( 'post_type_rest_endpoint_group', $this->settings_key );
		$post_types[] = nisje_get_setting( 'post_type_rest_endpoint', $this->settings_key );

		return $post_types;
	}
}
