<?php
/**
 * Plugin Name: Nisje - News
 * Description: Add a news to Nisje
 * Author:      Dekode
 * Author URI:  https://dekode.no/en/
 * Version:     5.0.6
 * Text Domain: nisje-news
 * Domain Path: /languages/
 * License:     GPLv2 or later (license.txt)
 *
 * @package Nisje
 */

declare( strict_types = 1 );

defined( 'ABSPATH' ) || die( 'Shame on you' );

define( 'NISJE_NEWS_VERSION', '5.0.6' );

/**
 * Load plugin textdomain.
 */
function nisje_news_load_textdomain() {
	load_plugin_textdomain( 'nisje-news', false, basename( __DIR__ ) . '/languages' );
}
add_action( 'plugins_loaded', 'nisje_news_load_textdomain' );

/**
 * Registers scripts and styles
 */
function nisje_news_register_scripts_and_styles() {
	wp_enqueue_script( 'nisje-plugin-news' );
}
add_action( 'wp_enqueue_scripts', 'nisje_news_register_scripts_and_styles', 20 );

/**
 * Include plugin components
 */
function nisje_news_include() {
	require __DIR__ . '/news/news.php';
}
add_action( 'nisje_include', 'nisje_news_include' );
