<?php
/**
 * Extend News Endpoint
 *
 * @package Nisje
 */

$endpoint               = nisje_get_setting( 'post_type_rest_endpoint', 'news' );
$taxonomy_name          = nisje_get_setting( 'taxonomy_category_name', 'news' );
$taxonomy_rest_endpoint = nisje_get_setting( 'taxonomy_category_rest_endpoint', 'news' );

$extend_objects = [
	nisje_get_setting( 'post_type_rest_endpoint', 'news' ),
	$taxonomy_rest_endpoint,
];

// Breadcrumb.
register_rest_field( $extend_objects, 'breadcrumb', [
	'get_callback' => function( $object, $field, $request ) use ( $taxonomy_name, $taxonomy_rest_endpoint ) {
		$retval = [];

		if ( strpos( $request->get_route(), $taxonomy_rest_endpoint ) !== false ) {
			$current_term = isset( $object['id'] ) ? $object['id'] : false;
		} else {
			$current_term = isset( $object[ $taxonomy_rest_endpoint ][0] ) ? $object[ $taxonomy_rest_endpoint ][0] : false;
		}

		if ( $current_term ) {
			$hierarchy = nisje_taxonomy_hierarchy( $current_term, $taxonomy_name, true );

			if ( is_array( $hierarchy ) ) {
				foreach ( $hierarchy as $category ) {
					if ( $category instanceof \WP_Term ) {
						$retval[] = [
							'id'   => $category->term_id,
							'name' => esc_html( $category->name ),
						];
					}
				}
			}
		}

		return $retval;
	},
	'schema'       => [
		'context'     => [ 'view', 'edit' ],
		'description' => esc_html__( 'Breadcrumb.', 'nisje-news' ),
		'type'        => 'array',
		'items'       => [
			'type' => 'string',
		],
		'readonly'    => true,
	],
] );
