<?php
/**
 * Setup Group News Post Type
 *
 * @package Nisje
 */

defined( 'ABSPATH' ) || die( 'Shame on you' );

$cap            = nisje_get_setting( 'capability_key_group', 'news' );
$post_type_name = nisje_get_setting( 'post_type_name_group', 'news' );
$rest_endpoint  = nisje_get_setting( 'post_type_rest_endpoint_group', 'news' );

$args = apply_filters(
	'nisje_news_post_type_group_args', [
		'labels'                => [
			'name'          => esc_html__( 'Group News', 'nisje' ),
			'singular_name' => esc_html__( 'Group News', 'nisje' ),
		],
		'public'                => true,
		'publicly_queryable'    => false,
		'exclude_from_search'   => false,
		'show_in_admin_bar'     => false,
		'show_in_nav_menus'     => false,
		'can_export'            => false,
		'show_ui'               => false,
		'query_var'             => false,
		'has_archive'           => false,
		'rewrite'               => false,
		'capability_type'       => $cap,
		'capabilities'          => [
			'create_posts'     => "create_{$cap}s",
			'delete_posts'     => "delete_{$cap}s",
			'upload_files_cpt' => "upload_files_{$cap}",
		],
		'map_meta_cap'          => true,
		'hierarchical'          => false,
		'menu_position'         => null,
		'menu_icon'             => 'dashicons-media-text',
		'supports'              => [
			'title',
			'revisions',
			'editor',
			'comments',
			'thumbnail',
			'author',
			'excerpt',
		],
		'show_in_rest'          => true,
		'rest_base'             => $rest_endpoint,
		'rest_controller_class' => '\\Dekode\\Nisje\\Components\\Rest\\Base_Group_Post_Controller',
	]
);

register_post_type( $post_type_name, $args ); // phpcs:ignore
