<?php
/**
 * Extend User Endpoint
 *
 * @package Nisje
 */

$extend_object = strtolower( buddypress()->groups->id );

// Add avatar URLs.
register_rest_field( $extend_object, 'avatar_urls', [
	'get_callback' => function( $object ) {
		return nisje_get_group_avatar( $object['id'] );
	},
	'schema'       => [
		'context'     => [ 'view', 'edit', 'member' ],
		'description' => esc_html__( 'Avatar URLs for the resource', 'nisje' ),
		'type'        => 'object',
		'properties'  => nisje_get_avatar_rest_properties(),
		'readonly'    => true,
	],
] );
