<?php
/**
 * Setup Access taxonomy.
 *
 * @package Nisje
 */

defined( 'ABSPATH' ) || die( 'Shame on you' );

$args = apply_filters( 'nisje_taxonomy_access_args', [
	'labels'            => [
		'name'          => esc_html_x( 'Access', 'taxonomy general name', 'nisje' ),
		'singular_name' => esc_html_x( 'Access', 'taxonomy singular name', 'nisje' ),
	],
	'hierarchical'      => false,
	'show_admin_column' => false,
	'show_ui'           => false,
	'query_var'         => false,
	'rewrite'           => false,
	'show_in_rest'      => false,
] );

$object_type = apply_filters( 'nisje_taxonomy_access_object_types', [ 'post', 'page' ] );

register_taxonomy( 'nisje-access', $object_type, $args );
