<?php
/**
 * Extend Settings Endpoint with Group Types.
 *
 * @package Nisje
 */

register_rest_field( 'settings', 'group_types', [
	'get_callback' => function( $object ) {
		$group_types = bp_groups_get_group_types( [], 'objects' );
		if ( $group_types ) {
			foreach ( $group_types as $key => $group_type ) {
				if ( ! empty( $group_type->directory_slug ) ) {
					$group_types[ $key ]->has_directory = $group_type->directory_slug;
				}
			}
		}

		return $group_types;
	},
	'schema'       => [
		'context'     => [ 'view' ],
		'description' => esc_html__( 'Group Types.', 'nisje' ),
		'type'        => 'array',
		'items'       => [
			'type' => 'string',
		],
		'readonly'    => true,
	],
] );
