<?php
/**
 * Extend Group Members Endpoint with Profile Fields
 *
 * @package Nisje
 */

defined( 'ABSPATH' ) || die( 'Shame on you' );

register_rest_field( 'group-member', 'profile_layouts', [
	'get_callback' => function( $object, $attr, $request ) {
		$retval = [];

		if ( 'listing' === $request['context'] ) {
			$retval = [
				'di_member_listing_fields' => nisje_get_user_profile_layouts( $object['id'], 'di_member_listing_fields' ),
			];
		} else {
			$retval = nisje_get_user_profile_layouts( $object['id'] );
		}

		return $retval;
	},
	'schema'       => [
		'context'     => [ 'view', 'edit', 'listing' ],
		'description' => esc_html__( 'Collection of profile fields', 'nisje' ),
		'type'        => 'array',
		'items'       => [
			'type' => 'object',
		],
		'readonly'    => true,
	],
] );
