<?php
/**
 * REST API: WP_REST_Post_Search_Handler class
 *
 * @package Nisje
 */

/**
 * Core class representing a search handler for posts in the REST API.
 *
 * @see WP_REST_Search_Handler
 */
class Groups_Search_Handler extends WP_REST_Search_Handler {

	/**
	 * Constructor.
	 */
	public function __construct() {
		$this->type = 'groups';
	}

	/**
	 * Searches the object type content for a given search request.
	 *
	 * @param WP_REST_Request $request Full REST request.
	 * @return array
	 */
	public function search_items( WP_REST_Request $request ) {
		$post_type_name = nisje_get_setting( 'post_type_name', 'user-content' );

		$user_id = bp_loggedin_user_id();

		$query_args = [
			'user'        => $user_id,
			'show_hidden' => true,
			'fields'      => 'ids',
		];

		if ( ! empty( $request['search'] ) ) {
			$query_args['search_terms'] = $request['search'];
		}

		if ( ! empty( $request['page'] ) ) {
			$query_args['page'] = $request['page'];
		}

		$groups = \groups_get_groups( $query_args );

		return [
			self::RESULT_IDS   => $groups['groups'],
			self::RESULT_TOTAL => $groups['total'],
		];
	}

	/**
	 * Prepares the search result for a given ID.
	 *
	 * @param int   $id     Item ID.
	 * @param array $fields Fields to include for the item.
	 * @return array Associative array containing all fields for the item.
	 */
	public function prepare_item( $id, array $fields ) {
		$post = \nisje_get_api_data( '/buddypress/v1/groups/' . $id )[0];

		unset( $post['_links'] );

		return $post;
	}

	/**
	 * Prepares links for the search result of a given ID.
	 *
	 * @param int $id Item ID.
	 * @return array Links for the given item.
	 */
	public function prepare_item_links( $id ) {
		return [];
	}
}
