<?php
/**
 * Remove unused Actions.
 *
 * @package Nisje
 */

namespace Dekode\Nisje\Resets;

/**
 * Remove unused hooks. Optimize.
 */
function remove_actions() {
	if ( ! is_admin() ) {
		// BuddyPress.
		remove_action( 'admin_bar_menu', 'bp_setup_admin_bar', 20 ); // After WP core.
		remove_action( 'widgets_init', 'bp_widgets_init', 10 );
		remove_action( 'bp_loaded', 'bp_setup_widgets', 6 );
		remove_action( 'bp_init', 'bp_setup_nav', 6 );
		remove_action( 'bp_init', 'bp_setup_title', 8 );
		remove_action( 'bp_init', 'bp_core_load_admin_bar_css', 12 );

		remove_filter( 'get_the_excerpt', 'wp_trim_excerpt' );
	}
}
add_action( 'plugins_loaded', __NAMESPACE__ . '\remove_actions', 1 );

/**
 * Remove enqueues
 */
function remove_enqueues() {
	if ( ! bp_is_register_page() ) {
		remove_action( 'wp_enqueue_scripts', 'bp_enqueue_scripts', 10 );
		remove_action( 'enqueue_embed_scripts', 'bp_enqueue_embed_scripts', 10 );
	}
}
add_action( 'wp_enqueue_scripts', __NAMESPACE__ . '\remove_enqueues', 1 );
