<?php
/**
 * Profile Layout Base class
 *
 * @package Nisje
 */

defined( 'ABSPATH' ) || die( 'Shame on you' );

/**
 * Profile Layout
 */
final class Nisje_Profile_Layout {
	/**
	 * Key.
	 *
	 * @var string
	 */
	public $key = '';

	/**
	 * Name.
	 *
	 * @var string
	 */
	public $name = '';

	/**
	 * Label.
	 *
	 * @var string
	 */
	public $label = '';

	/**
	 * Instructions.
	 *
	 * @var string
	 */
	public $instructions = '';

	/**
	 * Constructor
	 *
	 * @param string $key          Key.
	 * @param string $name         Name.
	 * @param string $label        Label.
	 * @param string $instructions Instructions.
	 */
	public function __construct( $key, $name, $label, $instructions = '' ) {
		$this->key          = sanitize_key( $key );
		$this->name         = sanitize_key( $name );
		$this->label        = esc_html( $label );
		$this->instructions = esc_html( $instructions );
	}
}
