<?php
/**
 * Extend BuddyPress groups
 *
 * @package Nisje
 */

defined( 'ABSPATH' ) || die( 'Shame on you' );

/**
 * Fix bug in BuddyPress groups
 */
add_filter( 'bp_rest_groups_collection_params', function( $params ) {
	$params['meta']['items'] = [ 'type' => 'object' ];

	return $params;
} );

/**
 * Membership status
 */
register_rest_field( 'bp_groups', 'is_member', [
	'get_callback' => function( $object ) {
		return (bool) \groups_is_user_member( get_current_user_id(), $object['id'] );
	},
	'schema'       => [
		'context'     => [ 'view', 'edit' ],
		'description' => 'Is member',
		'type'        => 'string',
		'readonly'    => true,
	],
] );

/**
 * Mod status
 */
register_rest_field( 'bp_groups', 'is_mod', [
	'get_callback' => function( $object ) {
		return (bool) \groups_is_user_mod( get_current_user_id(), $object['id'] );
	},
	'schema'       => [
		'context'     => [ 'view', 'edit' ],
		'description' => 'Is moderator',
		'type'        => 'string',
		'readonly'    => true,
	],
] );

/**
 * Admin status
 */
register_rest_field( 'bp_groups', 'is_admin', [
	'get_callback' => function( $object ) {
		return (bool) \groups_is_user_admin( get_current_user_id(), $object['id'] );
	},
	'schema'       => [
		'context'     => [ 'view', 'edit' ],
		'description' => 'Is admin',
		'type'        => 'string',
		'readonly'    => true,
	],
] );

/**
 * Pending status
 */
register_rest_field( 'bp_groups', 'is_membership_pending', [
	'get_callback' => function( $object ) {
		return (bool) \groups_check_for_membership_request( get_current_user_id(), $object['id'] );
	},
	'schema'       => [
		'context'     => [ 'view', 'edit' ],
		'description' => 'Is membership pending',
		'type'        => 'string',
		'readonly'    => true,
	],
] );

/**
 * Banned status
 */
register_rest_field( 'bp_groups', 'is_banned', [
	'get_callback' => function( $object ) {
		return (bool) \groups_is_user_banned( get_current_user_id(), $object['id'] );
	},
	'schema'       => [
		'context'     => [ 'view', 'edit' ],
		'description' => 'Is user banned',
		'type'        => 'string',
		'readonly'    => true,
	],
] );

/**
 * Pending status
 */
register_rest_field( 'bp_groups', 'membership_requests', [
	'get_callback' => function( $object ) {
		$user_id  = get_current_user_id();
		$is_mod   = (bool) \groups_is_user_mod( $user_id, $object['id'] );
		$is_admin = (bool) \groups_is_user_admin( $user_id, $object['id'] );

		if ( ! $is_mod && ! $is_admin ) {
			return 0;
		}

		$group_requests = groups_get_requests( [
			'item_id' => $object['id'],
		] );

		return (int) count( $group_requests );
	},
	'schema'       => [
		'context'     => [ 'view', 'edit' ],
		'description' => 'Membership requests',
		'type'        => 'int',
		'readonly'    => true,
	],
] );


register_rest_field( 'bp_group_membership_request', 'name', [
	'get_callback' => function( $object ) {
		$user = get_userdata( $object['user_id'] );
		return $user->display_name;
	},
	'schema'       => [
		'context'     => [ 'view', 'edit' ],
		'description' => 'Display name',
		'type'        => 'string',
		'readonly'    => true,
	],
] );
