<?php
/**
 * Setup notifications
 *
 * @package Nisje
 */

namespace Dekode\Nisje\Components\Mail_Notifications;

defined( 'ABSPATH' ) || die( 'Shame on you' );

/**
 * Register post mention notification
 *
 * @param int $post_id Post ID.
 * @param int $user_id   User ID.
 */
function post_mention_mail( $post_id, $user_id ) {
	if ( 'yes' === get_user_meta( $user_id, 'notification_new_mention', true ) ) {
		$post = get_post( $comment->comment_post_ID );

		if ( $post instanceof \WP_Post ) {
			$email_type = 'mention';

			$unsubscribe_args = [
				'user_id'           => $user_id,
				'notification_type' => 'notification_new_mention',
			];

			$args = [
				'tokens' => [
					'usermessage'      => wp_strip_all_tags( $post->post_content ),
					'poster.name'      => $post->post_author,
					'receiver-user.id' => $user_id,
					'unsubscribe'      => esc_url( bp_email_get_unsubscribe_link( $unsubscribe_args ) ),
				],
			];

			bp_send_email( $email_type, $user_id, $args );
		}
	}
}
add_action( 'nisje_post_mention', __NAMESPACE__ . '\post_mention_mail', 10, 2 );

/**
 * Register comment mention notification
 *
 * @param int $comment_id Comment ID.
 * @param int $user_id   User ID.
 */
function comment_mention_mail( $comment_id, $user_id ) {
	if ( 'yes' === get_user_meta( $user_id, 'notification_new_mention', true ) ) {
		$post = get_post( $comment->comment_post_ID );

		if ( $post instanceof \WP_Post ) {
			$email_type = 'groups-at-message';

			$unsubscribe_args = [
				'user_id'           => $user_id,
				'notification_type' => 'notification_new_mention',
			];

			$args = [
				'tokens' => [
					'usermessage'      => wp_strip_all_tags( $post->post_content ),
					'poster.name'      => $post->post_author,
					'receiver-user.id' => $user_id,
					'unsubscribe'      => esc_url( bp_email_get_unsubscribe_link( $unsubscribe_args ) ),
				],
			];

			bp_send_email( $email_type, $user_id, $args );
		}
	}
}
add_action( 'nisje_comment_mention', __NAMESPACE__ . '\comment_mention_mail', 10, 2 );

/**
 * Register comment notification
 *
 * @param WP_Comment      $comment  Inserted or updated comment object.
 * @param WP_REST_Request $request  Request object.
 * @param bool            $creating True when creating a comment, false when updating.
 */
function new_comment_mail( $comment, $request, $creating ) {
	$post = get_post( $comment->comment_post_ID );

	if ( $post instanceof \WP_Post ) {
		$user_id = $post->post_author;

		if ( 'yes' === get_user_meta( $user_id, 'notification_new_comment', true ) ) {
			$email_type = 'comment';

			$unsubscribe_args = [
				'user_id'           => $user_id,
				'notification_type' => 'notification_new_comment',
			];

			$args = [
				'tokens' => [
					'usermessage'      => wp_strip_all_tags( $post->post_content ),
					'poster.name'      => $post->post_author,
					'receiver-user.id' => $user_id,
					'unsubscribe'      => esc_url( bp_email_get_unsubscribe_link( $unsubscribe_args ) ),
				],
			];

			bp_send_email( $email_type, $user_id, $args );
		}
	}
}
add_action( 'rest_insert_comment', __NAMESPACE__ . '\new_comment_mail', 10, 3 );
