<?php
/**
 * Plugin Name: Nisje Community
 * Description: Core Community functionality. The mothership
 * Author:      Dekode
 * Author URI:  https://dekode.no/en/
 * Version:     8.0.4
 * Text Domain: nisje
 * License:     GPLv2 or later (license.txt)
 *
 * @package Nisje
 */

declare( strict_types = 1 );
defined( 'ABSPATH' ) || die( 'Shame on you' );

define( 'NISJE_CORE_VERSION', '8.0.4' );
define( 'NISJE_CORE_DB_VERSION', '0.0.12' );

/**
 * Returns the instance of Nisje to functions everywhere.
 *
 * @return Nisje|null The object.
 */
function nisje() {
	return Dekode\Nisje\Core::instance();
}

require __DIR__ . '/class-core.php';
require __DIR__ . '/includes/optimizations.php';
require __DIR__ . '/includes/helpers/helper-functions.php';

$GLOBALS['nisje'] = nisje();

/**
 * Remove core metaboxes
 */
function nisje_reset_admin_dashboard(): void {
	$remove_widgets_dashboard = [
		'dashboard_right_now',
		'dashboard_plugins',
		'dashboard_recent_drafts',
		'dashboard_incoming_links',
		'dashboard_quick_press',
		'dashboard_primary',
		'dashboard_secondary',
		'dashboard_site_health',
		'dashboard_welcome',
	];

	foreach ( $remove_widgets_dashboard as $remove_widget_dashboard ) {
		\remove_meta_box( $remove_widget_dashboard, 'dashboard', 'core' );
	}
}
\add_action( '_admin_menu', 'nisje_reset_admin_dashboard' );

/**
 * Remove php nag metabox
 */
function nisje_remove_php_nag() {
	\remove_meta_box( 'dashboard_php_nag', 'dashboard', 'normal' );
}
\add_action( 'wp_dashboard_setup', 'nisje_remove_php_nag' );
