<?php
/**
 * Plugin Name: Nisje Community
 * Description: Core Community functionality. The mothership
 * Author:      Dekode
 * Author URI:  https://dekode.no/en/
 * Version:     9.0.2
 * Text Domain: nisje
 * License:     GPLv2 or later (license.txt)
 *
 * @package Nisje
 */

declare( strict_types = 1 );

define( 'NISJE_CORE_DIR_PATH', \plugin_dir_path( __FILE__ ) );
define( 'NISJE_CORE_VERSION', '9.0.2' );
define( 'NISJE_CORE_DB_VERSION', '0.0.12' );

/**
 * Returns the instance of Nisje to functions everywhere.
 *
 * @return Nisje|null The object.
 */
function nisje() {
	return Dekode\Nisje\Core::instance();
}

require __DIR__ . '/class-core.php';
require __DIR__ . '/includes/extensions.php';
require __DIR__ . '/includes/optimizations.php';
require __DIR__ . '/includes/helpers/helper-functions.php';

$GLOBALS['nisje'] = nisje();

/**
 * Remove core metaboxes
 */
function nisje_reset_admin_dashboard(): void {
	$remove_widgets_dashboard = [
		'dashboard_right_now',
		'dashboard_plugins',
		'dashboard_recent_drafts',
		'dashboard_incoming_links',
		'dashboard_quick_press',
		'dashboard_primary',
		'dashboard_secondary',
		'dashboard_site_health',
		'dashboard_welcome',
	];

	foreach ( $remove_widgets_dashboard as $remove_widget_dashboard ) {
		\remove_meta_box( $remove_widget_dashboard, 'dashboard', 'core' );
	}
}
\add_action( '_admin_menu', 'nisje_reset_admin_dashboard' );

/**
 * Remove php nag metabox
 */
function nisje_remove_php_nag() {
	\remove_meta_box( 'dashboard_php_nag', 'dashboard', 'normal' );
}
\add_action( 'wp_dashboard_setup', 'nisje_remove_php_nag' );

/**
 * Active T2 if not activated
 */
\add_action( 'plugins_loaded', function() {
	if ( ! defined( 'T2_VERSION' ) ) {
		require_once ABSPATH . '/wp-admin/includes/plugin.php';
		\activate_plugins( [ 't2/t2.php' ] );
	}

	if ( ! class_exists( 'WPGraphQL' ) ) {
		require_once ABSPATH . '/wp-admin/includes/plugin.php';
		\activate_plugins( [ 'wp-graphql/wp-graphql.php' ] );
	}
} );
