<?php
/**
 * Dekode Secure BP Attachment Class
 *
 * @package Nisje
 */

defined( 'ABSPATH' ) || die( 'Shame on you' );

if ( class_exists( 'Dekode_BP_Attachment' ) ) :
	/**
	 * Attachment Secure Class
	 */
	class Dekode_Secure_BP_Attachment extends Dekode_BP_Attachment {
		/**
		 * Document ID
		 *
		 * @var int
		 */
		public $document_id;

		/**
		 * Dekode_Secure_BP_Attachment Constructor
		 *
		 * @param array $args Constructor arguments.
		 */
		public function __construct( $args = [] ) {
			parent::__construct();
		}

		/**
		 * Upload file and return result
		 *
		 * @param array  $file              File.
		 * @param string $upload_dir_filter Upload dir filter.
		 * @param null   $time              Time.
		 *
		 * @return array
		 */
		public function upload( $file, $upload_dir_filter = '', $time = null ) {
			$this->document_id = $this->generate_cpt( $file );

			$result = parent::upload( $file, $upload_dir_filter, $time );

			$my_post = [
				'ID'           => $this->document_id,
				'post_content' => $this->attachment_id,
			];

			wp_update_post( $my_post );

			$result['ID']  = $this->document_id;
			$result['url'] = get_permalink( $this->document_id );

			return $result;
		}

		/**
		 * Make a new post of post type document to hide and serve uploaded file
		 *
		 * @param array $file Array with file to be uploaded.
		 *
		 * @return int ID of new post
		 */
		private function generate_cpt( $file ) {
			// Create post object.
			$my_post = [
				'post_title'  => wp_strip_all_tags( $file[ $this->file_input ]['name'] ),
				'post_status' => 'publish',
				'post_type'   => 'document',
			];

			return wp_insert_post( $my_post );
		}


		/**
		 * Override upload to change file name
		 *
		 * @param array $overrides Overrides.
		 *
		 * @return array
		 */
		public function upload_overrides( $overrides ) {
			$overrides = parent::upload_overrides( $overrides );

			$overrides['unique_filename_callback'] = [ $this, 'regenerate_filename' ];

			return $overrides;
		}

		/**
		 * Change filename to md5 code
		 *
		 * @param string $directory Directory.
		 * @param string $name      Name.
		 * @param strong $extension Extension.
		 *
		 * @return string
		 */
		public function regenerate_filename( $directory, $name, $extension ) {
			return md5( $name . time() ) . $extension;
		}

		/**
		 * Set what folder to upload to based on id of current user. Also put it in folder that is hidden.
		 *
		 * @param array $upload_dir Upload dir.
		 *
		 * @return array
		 */
		public function upload_dir_filter( $upload_dir = [] ) {
			$upload_dir_data = parent::upload_dir_filter();

			if ( ! is_user_logged_in() ) {
				return $upload_dir_data;
			}

			// Set upload dir with filter.
			return [
				'path'    => $this->upload_path . '/se/' . bp_loggedin_user_id(),
				'url'     => $this->url . '/se/' . bp_loggedin_user_id(),
				'subdir'  => '/se/' . bp_loggedin_user_id(),
				'basedir' => $this->upload_path . '/se/' . bp_loggedin_user_id(),
				'baseurl' => $this->url . '/se/' . bp_loggedin_user_id(),
				'error'   => false,
			];
		}
	}

endif;
