<?php
/**
 * Extensions
 *
 * @package Nisje
 */

declare( strict_types = 1 );
namespace Nisje\Extensions;

/**
 * Register extensions
 */
if ( function_exists( 'T2\Extensions\register_extension' ) ) {
	foreach ( glob( NISJE_CORE_DIR_PATH . 'extensions/*', GLOB_ONLYDIR ) as $dir ) {
		\T2\Extensions\register_extension( 'nisje/' . basename( $dir ), "$dir/extension.php" );
	}
}

/**
 * Remove unwanted T2 extensions
 *
 * @param array $extensions Extensions.
 */
function remove_t2_extensions( array $extensions ): array {
	$allowed_extensions = [
		't2/disable-admin-toolbar',
		't2/disable-block-directory',
		't2/disable-custom-css',
		't2/disable-emoji',
		't2/disable-full-site-editing',
		't2/disable-xmlrpc',
		't2/remove-core-patterns',
		't2/table-of-contents',
	];

	$extensions = array_filter( $extensions, function( string $block ) use ( $allowed_extensions ): bool {
		return substr( $block, 0, 3 ) !== 't2/' || in_array( $block, $allowed_extensions, true );
	}, ARRAY_FILTER_USE_KEY );

	return $extensions;
}

/**
 * Remove unwanted T2 blocks
 *
 * @param array $blocks Blocks.
 */
function remove_t2_blocks( array $blocks ): array {
	$allowed_blocks = [ 't2/ingress', 't2/infobox', 't2/files' ];

	$blocks = array_filter( $blocks, function( string $block ) use ( $allowed_blocks ): bool {
		return substr( $block, 0, 3 ) !== 't2/' || in_array( $block, $allowed_blocks, true );
	}, ARRAY_FILTER_USE_KEY );

	return $blocks;
}

\add_action( 'init', function() {
	\add_filter( 't2/extensions/available', __NAMESPACE__ . '\\remove_t2_extensions' );
	\add_filter( 't2/blocks/available', __NAMESPACE__ . '\\remove_t2_blocks' );
});
