<?php
/**
 * Extend BuddyPress group invites
 *
 * @package Nisje
 */

namespace Nisje\RestApi\BuddyPress\Groups\Invites;

/**
 * Add group name to invites.
 */
\register_rest_field( 'bp_group_invites', 'group_name', [
	'get_callback' => function( $object ) {
		$group = groups_get_group( $object['group_id'] );
		return \bp_get_group_name( $group );
	},
	'schema'       => [
		'context'     => [ 'view' ],
		'description' => 'The name of the group to which the user has been invited.',
		'type'        => 'string',
		'readonly'    => true,
	],
] );
