# Nisje
Core Community functionality. Add Rest Endpoints to help building the Nisje Community Application.

## Plugin dependency
Activate these plugins before activating Nisje:
BuddyPress, ACF, JWT

## Installation
- Upload the nisje folder to the plugins directory
- Activate the Nisje plugin through the 'Plugins' menu in WordPress

## Running tests locally
Running tests locally can be beneficial during development as it is quicker than
committing changes and waiting for Travis CI to run the tests.

We’re going to assume that you have installed `git`, `svn`, `php`, `apache` and
`PHPUnit`

1. Initialize the testing environment locally: `cd` into the plugin directory
   and run the install script (you will need to have `wget` installed).

   ```bash
   bin/install-wp-tests.sh wordpress_test root '' localhost latest
   ```

   The install script first it installs a copy of WordPress in the `/tmp` directory
   (by default) as well as the WordPress unit testing tools. Then it creates a
   database to be used while running tests. The parameters that are passed to
   `install-wp-tests.sh` setup the test database.

   * `wordpress_test` is the name of the test database (all data will be deleted!)
   * `root` is the MySQL user name
   * `''` is the MySQL user password
   * `localhost` is the MySQL server host
   * `latest` is the WordPress version; could also be 3.7, 3.6.2 etc.

2. Run the plugin tests:

   ```bash
   phpunit
   ```

For more info see https://make.wordpress.org/cli/handbook/plugin-unit-tests/#running-tests-locally
