<?php
/**
 * Reaction graphql
 *
 * @package Nisje
 */

namespace Nisje\Reaction\GraphQL;

\add_action( 'graphql_register_types', __NAMESPACE__ . '\\extend_wpgraphql_schema' );

/**
 * Extend WPGraphQL schema
 */
function extend_wpgraphql_schema() {
	\register_graphql_object_type( 'ReactedType', [
		'description' => 'Get reaction',
		'fields'      => [
			'reacted' => [
				'type'        => 'Boolean',
				'description' => 'Has the current user reacted',
			],
			'total'   => [
				'type'        => 'Int',
				'description' => 'Number of reactions',
			],
		],
	] );

	\register_graphql_field( 'RootQuery', 'reacted', [
		'type'    => 'ReactedType',
		'args'    => [
			'id'      => [
				'type'        => 'ID',
				'description' => 'Object id',
			],
			'context' => [
				'type'        => 'String',
				'description' => 'Object context',
			],
		],
		'resolve' => function( $source, $args ) {
			if ( isset( $args['id'] ) && isset( $args['context'] ) ) {
				return \nisje_get_user_reactions( $args['id'], $args['context'] );
			}

			return null;
		},
	] );
}
