<?php
/**
 * The `t2/featured-card` block.
 *
 * @package T2
 */

declare( strict_types = 1 );
namespace T2\BlockLibrary\FeaturedCard;

/**
 * Render
 *
 * @param array  $attributes Block attributes.
 * @param string $content    Block content.
 */
function render( array $attributes, string $content ): string {
	$content = '<div class="t2-featured-card__content">' . $content . '</div>';

	if ( ! empty( $attributes['mediaId'] ) ) {
		$image_wrapper = \wp_get_attachment_image( $attributes['mediaId'], 'medium_large', false, [
			'style' => sprintf( 'object-position: %s%% %s%%;', $attributes['focalPoint']['x'] * 100, $attributes['focalPoint']['y'] * 100 ),
		] );

		$content = '<div class="t2-featured-card__image">' . $image_wrapper . '</div>' . $content;
	}

	if ( ! empty( $attributes['url'] ) ) {
		$wrapper_attributes = \get_block_wrapper_attributes(
			[
				'href' => $attributes['url'],
			]
		);
		return sprintf( '<a %s>%s</a>', $wrapper_attributes, $content );
	}

	$wrapper_attributes = \get_block_wrapper_attributes();
	return sprintf( '<div %s>%s</div>', $wrapper_attributes, $content );
}

/**
 * Register block.
 */
\register_block_type( __DIR__, [
	'render_callback' => __NAMESPACE__ . '\\render',
] );
