<?php
/**
 * Wiki Group Admin.
 *
 * @package Nisje
 */

declare( strict_types = 1 );
namespace Nisje\Extension\Wiki\Groups\Admin;

use const Nisje\Extension\Wiki\Groups\POST_TYPE_NAME;

/**
 * Remove quick edit.
 *
 * @param array    $actions Actions.
 * @param \WP_Post $post Post.
 */
function remove_quick_edit( array $actions, \WP_Post $post ): array {
	// Check for your post type.
	if ( POST_TYPE_NAME === $post->post_type ) {
		unset( $actions['inline hide-if-no-js'] );
	}

	return $actions;
}
\add_filter( 'post_row_actions', __NAMESPACE__ . '\\remove_quick_edit', 10, 2 );
