<?php
/**
 * Wiki Group Rest API.
 *
 * @package Nisje
 */

declare( strict_types = 1 );
namespace Nisje\Extension\Wiki\Groups\Rest;

/**
 * Register REST API endpoints.
 */
function register_rest_routes() {
	// Extend BuddyPress Groups REST API.
	\register_rest_field( 'bp_groups', 'enable_wiki', [
		'get_callback' => function( $object ) {
			return (bool) \groups_get_groupmeta( $object['id'], '_nisje_wiki_enabled', true );
		},
		'schema'       => [
			'context'     => [ 'view', 'edit' ],
			'description' => 'Is group wiki enabled',
			'type'        => 'bool',
			'readonly'    => true,
		],
	] );
}
\add_action( 'rest_api_init', __NAMESPACE__ . '\\register_rest_routes' );
