<?php
/**
 * Wiki Settings.
 *
 * @package Nisje
 */

declare( strict_types = 1 );
namespace Nisje\Extension\Wiki\Settings;

use function Nisje\Extension\Wiki\Utils\{
	get_title,
	get_slug
};

/**
 * Add settings
 *
 * @param array $settings Settings.
 */
function add_settings( array $settings ): array {
	$settings['wikiTitle'] = get_title();
	$settings['wikiSlug']  = get_slug();

	return $settings;
}
\add_filter( 'nisje_frontend_options', __NAMESPACE__ . '\\add_settings' );
