<?php
/**
 * Setup Customizer Component
 *
 * @package Nisje
 */

namespace Dekode\Nisje\Components;

defined( 'ABSPATH' ) || die( 'Shame on you' );

/**
 * Customizer Component Class
 */
class Customizer extends Component {
	/**
	 * Constructor
	 */
	public function __construct() {
		parent::start(
			'customizer',
			__( 'Customizer', 'nisje' )
		);
	}

	/**
	 * Global variables
	 */
	public function setup_globals() {
		$this->group_key   = 'nisje_design_options';
		$this->prepend_key = 'nisje_';
		$this->key         = 'customizer';

		$defaults = [
			'group_key'   => $this->group_key,
			'prepend_key' => $this->prepend_key,
			'key'         => $this->key,
		];

		$this->settings = wp_parse_args( $this->settings, $defaults );
	}

	/**
	 * Includes
	 */
	public function includes() {
		nisje_include( 'includes/components/customizer/helper-functions.php' );
	}

	/**
	 * Setup Filters
	 */
	public function setup_filters() {
		add_action( 'customize_register', [ $this, 'register_customizer' ] );
	}

	/**
	 * Register Customizer functionality
	 *
	 * @param object $wp_customize Customizer object.
	 */
	public function register_customizer( $wp_customize ) {
		$group_key   = nisje_get_setting( 'group_key', $this->settings_key );
		$prepend_key = nisje_get_setting( 'prepend_key', $this->settings_key );

		// Main group.
		$wp_customize->add_section(
			$group_key,
			[
				'title'    => __( 'Design', 'nisje' ),
				'priority' => 35,
			]
		);

		/**
		 * Font option.
		 */
		nisje_customizer_add_setting(
			$wp_customize, [
				'label'         => __( 'Font', 'nisje' ),
				'section'       => $group_key,
				'settings'      => $prepend_key . 'font',
				'type'          => 'select',
				'choices'       => [
					'circular'   => 'Circular',
					'montserrat' => 'Montserrat',
					'lato'       => 'Lato',
				],
				'nisje_default' => 'circular',
			]
		);
	}
}
