<?php
/**
 * Wiki Group Admin.
 *
 * @package Nisje
 */

declare( strict_types = 1 );
namespace Nisje\Extension\Wiki\Groups\Admin;

use const Nisje\Extension\Wiki\Groups\POST_TYPE_NAME;
use function Nisje\Extension\Wiki\Utils\get_slug;

/**
 * Remove quick edit.
 *
 * @param array    $actions Actions.
 * @param \WP_Post $post Post.
 */
function remove_quick_edit( array $actions, \WP_Post $post ): array {
	// Check for your post type.
	if ( POST_TYPE_NAME === $post->post_type ) {
		unset( $actions['inline hide-if-no-js'] );
	}

	return $actions;
}
\add_filter( 'post_row_actions', __NAMESPACE__ . '\\remove_quick_edit', 10, 2 );

/**
 * Edit link on group wiki posts should go to frontend.
 *
 * @param string $link Link.
 * @param int    $id   Post id.
 */
function edit_link( string $link, int $id ): string {
	$current_post = \get_post( $id );

	if ( ! $current_post || POST_TYPE_NAME !== $current_post->post_type ) {
		return $link;
	}

	$slug = get_slug();
	return \home_url( '/groups/' . $current_post->post_parent . '/' . $slug . '/' . $current_post->ID . '/edit/' );
}
\add_filter( 'get_edit_post_link', __NAMESPACE__ . '\\edit_link', 10, 2 );

/**
 * Hides the add new links.
 *
 * @param array $caps Capabilities.
 */
function hide_add_new_link( array $caps ): array {
	if ( \is_admin() ) {
		unset( $caps['create_nisje_wiki_cap_groups'] );
	}

	return $caps;
}
\add_filter( 'user_has_cap', __NAMESPACE__ . '\\hide_add_new_link' );
