<?php
/**
 * Setup Group Wiki Post Type
 *
 * @package Nisje
 */

namespace Nisje\Extension\Wiki\Groups\PostType;

use const Nisje\Extension\Wiki\Groups\POST_TYPE_NAME;

/**
 * Register the Group Wiki post type.
 */
function register_post_type() {
	$cap           = \nisje_get_setting( 'capability_key_group', 'wiki' );
	$rest_endpoint = \nisje_get_setting( 'post_type_rest_endpoint_group', 'wiki' );

	\register_post_type( POST_TYPE_NAME, [
		'labels'                => [
			'name'          => \esc_html__( 'Group Wiki', 'nisje' ),
			'singular_name' => \esc_html__( 'Group Wiki', 'nisje' ),
		],
		'public'                => true,
		'publicly_queryable'    => false,
		'exclude_from_search'   => false,
		'show_in_admin_bar'     => false,
		'show_in_nav_menus'     => false,
		'can_export'            => false,
		'show_ui'               => true,
		'query_var'             => false,
		'has_archive'           => false,
		'rewrite'               => false,
		'capability_type'       => $cap,
		'capabilities'          => [
			'create_posts'     => "create_{$cap}s",
			'delete_posts'     => "delete_{$cap}s",
			'upload_files_cpt' => "upload_files_{$cap}",
		],
		'map_meta_cap'          => true,
		'hierarchical'          => false,
		'menu_position'         => null,
		'menu_icon'             => 'dashicons-media-text',
		'supports'              => [
			'title',
			'revisions',
			'editor',
			'comments',
			'thumbnail',
			'author',
			'excerpt',
		],
		'show_in_rest'          => true,
		'rest_base'             => $rest_endpoint,
		'rest_controller_class' => '\\Dekode\\Nisje\\Components\\Rest\\Base_Group_Post_Controller',
	] );
}
\add_action( 'init', __NAMESPACE__ . '\\register_post_type' );

/**
 * Add feed post types.
 *
 * @param array $post_types Current Post Types.
 * @return array $post_types Populated Post Types.
 */
function add_feed_post_types( array $post_types ): array {
	$post_types[] = POST_TYPE_NAME;
	return $post_types;
}
\add_filter( 'nisje_feed_post_types', __NAMESPACE__ . '\\add_feed_post_types' );
