<?php
/**
 * Wiki Group settings.
 *
 * @package Nisje
 */

declare( strict_types = 1 );
namespace Nisje\Extension\Wiki\Groups;

use function Nisje\Extension\Wiki\Utils\get_title;

/**
 * Add group features
 *
 * @param array $features Features.
 */
function add_group_feature( array $features ): array {
	$features['enable_wiki'] = [
		'label'       => get_title(),
		'description' => \__( 'Enable articles', 'nisje' ),
	];

	return $features;
}
\add_filter( 'nisje_group_features', __NAMESPACE__ . '\\add_group_feature', 50 );
