<?php
/**
 * Setup Feed Component
 *
 * @package Nisje
 */

namespace Dekode\Nisje\Components;

defined( 'ABSPATH' ) || die( 'Shame on you' );

if ( ! class_exists( '\\Dekode\\Nisje\\Components\\Feed' ) && class_exists( '\\Dekode\\Nisje\\Components\\Component' ) ) {

	/**
	 * Feed Component Class
	 */
	class Feed extends Component {
		/**
		 * Constructor
		 */
		public function __construct() {
			$path = trailingslashit( __DIR__ );

			parent::start(
				'feed',
				esc_html__( 'Feed', 'nisje' ),
				$path
			);
		}

		/**
		 * Setup actions
		 */
		public function setup_filters() {
			add_filter( 'nisje_rest_shared_fields_group_post_types', [ $this, 'add_shared_rest_group_fields' ] );
			add_filter( 'nisje_rest_shared_fields_post_types', [ $this, 'add_shared_rest_fields' ] );
		}

		/**
		 * Register REST Endpoints
		 */
		public function register_rest_routes() {
			$this->include_file( 'rest-handlers/class-feed-controller.php' );

			$controller = new \Dekode\Nisje\Components\Rest\Feed_Controller();
			$controller->register_routes();
		}

		/**
		 * Extend rest group types.
		 *
		 * @param array $post_types Current Post Types.
		 * @return array $post_types Populated Post Types.
		 */
		public function add_shared_rest_group_fields( $post_types ) {
			$post_types[] = 'feed';

			return $post_types;
		}

		/**
		 * Extend rest post types.
		 *
		 * @param array $post_types Current Post Types.
		 * @return array $post_types Populated Post Types.
		 */
		public function add_shared_rest_fields( $post_types ) {
			$post_types[] = 'feed';

			return $post_types;
		}
	}
}
