<?php
/**
 * Setup Group Wiki Post Type
 *
 * @package Nisje
 */

namespace Nisje\Extension\Wiki\Groups\PostType;

use const Nisje\Extension\Wiki\Groups\{
	POST_TYPE_NAME,
	GROUP_META_KEY
};
use function Nisje\GroupConnection\Utils\add_group_connection_meta;

/**
 * Add meta connection
 */
add_group_connection_meta( POST_TYPE_NAME, GROUP_META_KEY );

/**
 * Register the Group Wiki post type.
 */
function register_post_type() {
	$cap           = 'global_group_post';
	$rest_endpoint = \nisje_get_setting( 'post_type_rest_endpoint_group', 'wiki' );

	\register_post_type( POST_TYPE_NAME, [
		'labels'                => [
			'name'          => \__( 'Group Wiki', 'nisje' ),
			'singular_name' => \__( 'Group Wiki', 'nisje' ),
		],
		'public'                => true,
		'publicly_queryable'    => true,
		'exclude_from_search'   => false,
		'show_in_admin_bar'     => false,
		'show_in_nav_menus'     => false,
		'can_export'            => false,
		'show_ui'               => true,
		'query_var'             => false,
		'has_archive'           => false,
		'rewrite'               => false,
		'capability_type'       => $cap,
		'capabilities'          => [
			'create_posts'     => "create_{$cap}s",
			'delete_posts'     => "delete_{$cap}s",
			'upload_files_cpt' => "upload_files_{$cap}",
		],
		'rewrite'               => [
			'slug'       => 'groups/%group_id%/wiki/%post_id%',
			'with_front' => false,
		],
		'map_meta_cap'          => true,
		'hierarchical'          => false,
		'menu_position'         => null,
		'menu_icon'             => 'dashicons-media-text',
		'supports'              => [
			'author',
			'editor',
			'excerpt',
			'revisions',
			'thumbnail',
			'title',
		],
		'show_in_rest'          => true,
		'rest_base'             => $rest_endpoint,
		'rest_controller_class' => '\\Dekode\\Nisje\\Components\\Rest\\Base_Group_Post_Controller',
		'show_in_graphql'       => true,
		'graphql_single_name'   => 'groupWiki',
		'graphql_plural_name'   => 'groupWikis',
	] );
}
\add_action( 'init', __NAMESPACE__ . '\\register_post_type' );

/**
 * Add feed post types.
 *
 * @param array $post_types Current Post Types.
 * @return array $post_types Populated Post Types.
 */
function add_feed_post_types( array $post_types ): array {
	$post_types[] = POST_TYPE_NAME;
	return $post_types;
}
\add_filter( 'nisje_feed_post_types', __NAMESPACE__ . '\\add_feed_post_types' );

/**
 * Override permissions for group wiki.
 *
 * @param bool   $allowed   Current permission.
 * @param string $post_type Post type.
 */
function override_rest_permission_check( $allowed, $post_type ) {
	if ( POST_TYPE_NAME === $post_type ) {
		return true;
	}

	return $allowed;
}
\add_filter( 'nisje_override_rest_permission_check', __NAMESPACE__ . '\\override_rest_permission_check', 10, 2 );
