<?php
/**
 * Setup Profile Layout Settings.
 *
 * @package Nisje
 */

defined( 'ABSPATH' ) || die( 'Shame on you' );

$layouts = [
	[
		'key'        => 'di_key_profile_layout',
		'label'      => esc_html__( 'BuddyPress Profile Field', 'nisje' ),
		'name'       => 'di_profile_layout',
		'display'    => 'block',
		'sub_fields' => [
			[
				'key'               => 'di_key_prepend_profile_field',
				'label'             => esc_html__( 'Prepend text', 'nisje' ),
				'name'              => 'di_prepend_field',
				'type'              => 'text',
				'instructions'      => '',
				'required'          => 0,
				'conditional_logic' => 0,
				'wrapper'           => [
					'width' => '33',
					'class' => '',
					'id'    => '',
				],
				'default_value'     => '',
				'placeholder'       => '',
				'prepend'           => '',
				'append'            => '',
				'maxlength'         => '',
			],
			[
				'key'               => 'di_key_profile_field',
				'label'             => esc_html__( 'BuddyPress Profile Field', 'nisje' ),
				'name'              => 'di_profile_field',
				'type'              => 'bp_profile_fields',
				'instructions'      => '',
				'required'          => 0,
				'conditional_logic' => [],
				'wrapper'           => [
					'width' => '33',
					'class' => '',
					'id'    => '',
				],
				'return_format'     => 'id',
				'multiple'          => 0,
				'ui'                => 0,
				'allow_null'        => 0,
				'placeholder'       => '',
			],
			[
				'key'               => 'di_key_format_profile_field',
				'label'             => esc_html__( 'Text Format', 'nisje' ),
				'name'              => 'di_format_field',
				'type'              => 'select',
				'instructions'      => '',
				'required'          => 0,
				'conditional_logic' => [],
				'wrapper'           => [
					'width' => '33',
					'class' => '',
					'id'    => '',
				],
				'choices'           => [
					'normal' => 'Normal',
					'bold'   => 'Bold',
					'italic' => 'Italic',
				],
				'default_value'     => [
					'normal',
				],
				'allow_null'        => 0,
				'multiple'          => 0,
				'ui'                => 0,
				'ajax'              => 0,
				'return_format'     => 'value',
				'placeholder'       => '',
			],
		],
		'min'        => '',
		'max'        => '',
	],
	[
		'key'        => 'di_key_wp_layout',
		'label'      => esc_html__( 'WordPress Field', 'nisje' ),
		'name'       => 'di_wp_layout',
		'display'    => 'block',
		'sub_fields' => [
			[
				'key'               => 'di_key_prepend_wp_field',
				'label'             => esc_html__( 'Prepend text', 'nisje' ),
				'name'              => 'di_prepend_field',
				'type'              => 'text',
				'instructions'      => '',
				'required'          => 0,
				'conditional_logic' => 0,
				'wrapper'           => [
					'width' => '33',
					'class' => '',
					'id'    => '',
				],
				'default_value'     => '',
				'placeholder'       => '',
				'prepend'           => '',
				'append'            => '',
				'maxlength'         => '',
			],
			[
				'key'               => 'di_key_wp_field',
				'label'             => esc_html__( 'WordPress Field', 'nisje' ),
				'name'              => 'di_wp_field',
				'type'              => 'select',
				'instructions'      => '',
				'required'          => 0,
				'conditional_logic' => [],
				'wrapper'           => [
					'width' => '33',
					'class' => '',
					'id'    => '',
				],
				'choices'           => [
					'user_email'    => 'E-mail',
					'description'   => 'Bio',
					'nickname'      => 'Nickname',
					'user_nicename' => 'Nicename',
				],
				'default_value'     => [
					'email',
				],
				'allow_null'        => 0,
				'multiple'          => 0,
				'ui'                => 0,
				'ajax'              => 0,
				'return_format'     => 'value',
				'placeholder'       => '',
			],
			[
				'key'               => 'di_key_format_wp_field',
				'label'             => esc_html__( 'Text Format', 'nisje' ),
				'name'              => 'di_format_field',
				'type'              => 'select',
				'instructions'      => '',
				'required'          => 0,
				'conditional_logic' => [],
				'wrapper'           => [
					'width' => '33',
					'class' => '',
					'id'    => '',
				],
				'choices'           => [
					'normal' => 'Normal',
					'bold'   => 'Bold',
					'italic' => 'Italic',
				],
				'default_value'     => [
					'normal',
				],
				'allow_null'        => 0,
				'multiple'          => 0,
				'ui'                => 0,
				'ajax'              => 0,
				'return_format'     => 'value',
				'placeholder'       => '',
			],
		],
		'min'        => '',
		'max'        => '',
	],
];

$custom = apply_filters( 'nisje_custom_profile_layouts', [] );

if ( is_array( $custom ) && ! empty( $custom ) ) {
	$layouts[] = [
		'key'        => 'di_key_custom_layout',
		'label'      => esc_html__( 'Custom Field', 'nisje' ),
		'name'       => 'di_custom_layout',
		'display'    => 'block',
		'sub_fields' => [
			[
				'key'               => 'di_key_prepend_custom_field',
				'label'             => esc_html__( 'Prepend text', 'nisje' ),
				'name'              => 'di_prepend_field',
				'type'              => 'text',
				'instructions'      => '',
				'required'          => 0,
				'conditional_logic' => 0,
				'wrapper'           => [
					'width' => '33',
					'class' => '',
					'id'    => '',
				],
				'default_value'     => '',
				'placeholder'       => '',
				'prepend'           => '',
				'append'            => '',
				'maxlength'         => '',
			],
			[
				'key'               => 'di_key_custom_field',
				'label'             => esc_html__( 'Custom Field', 'nisje' ),
				'name'              => 'di_custom_field',
				'type'              => 'select',
				'instructions'      => '',
				'required'          => 0,
				'conditional_logic' => [],
				'wrapper'           => [
					'width' => '33',
					'class' => '',
					'id'    => '',
				],
				'choices'           => $custom,
				'default_value'     => [],
				'allow_null'        => 0,
				'multiple'          => 0,
				'ui'                => 0,
				'ajax'              => 0,
				'return_format'     => 'value',
				'placeholder'       => '',
			],
			[
				'key'               => 'di_key_format_custom_field',
				'label'             => esc_html__( 'Text Format', 'nisje' ),
				'name'              => 'di_format_field',
				'type'              => 'select',
				'instructions'      => '',
				'required'          => 0,
				'conditional_logic' => [],
				'wrapper'           => [
					'width' => '33',
					'class' => '',
					'id'    => '',
				],
				'choices'           => [
					'normal' => 'Normal',
					'bold'   => 'Bold',
					'italic' => 'Italic',
				],
				'default_value'     => [
					'normal',
				],
				'allow_null'        => 0,
				'multiple'          => 0,
				'ui'                => 0,
				'ajax'              => 0,
				'return_format'     => 'value',
				'placeholder'       => '',
			],
		],
		'min'        => '',
		'max'        => '',
	];
}

$registered_layouts = nisje_get_profile_layouts();
$layouts_array      = [];
$counter            = 1;

if ( ! empty( $registered_layouts ) ) {
	foreach ( $registered_layouts as $registered_layout ) {
		if ( isset( $registered_layout->key, $registered_layout->label, $registered_layout->name ) ) {
			$layouts_array[] = [
				'key'               => 'di_key_tab_profile_field_' . $counter,
				'label'             => $registered_layout->label,
				'name'              => '',
				'type'              => 'tab',
				'instructions'      => '',
				'required'          => 0,
				'conditional_logic' => 0,
				'wrapper'           => [
					'width' => '',
					'class' => '',
					'id'    => '',
				],
				'placement'         => 'left',
				'endpoint'          => 0,
			];

			$layouts_array[] = [
				'key'               => $registered_layout->key,
				'label'             => $registered_layout->label,
				'name'              => $registered_layout->name,
				'type'              => 'flexible_content',
				'instructions'      => $registered_layout->instructions,
				'required'          => 0,
				'conditional_logic' => 0,
				'wrapper'           => [
					'width' => '',
					'class' => '',
					'id'    => '',
				],
				'button_label'      => esc_html__( 'Add field', 'nisje' ),
				'min'               => '',
				'max'               => '',
				'layouts'           => $layouts,
			];
		}

		$counter++;
	}
}

acf_add_local_field_group(
	[
		'key'                   => 'di_group_option_profile_layouts',
		'title'                 => esc_html__( 'Profile Layouts', 'nisje' ),
		'fields'                => $layouts_array,
		'location'              => [
			[
				[
					'param'    => 'options_page',
					'operator' => '==',
					'value'    => nisje_get_setting( 'settings_menu_key', 'profile_layouts' ),
				],
			],
		],
		'menu_order'            => 0,
		'position'              => 'normal',
		'style'                 => 'default',
		'label_placement'       => 'top',
		'instruction_placement' => 'label',
		'hide_on_screen'        => '',
		'active'                => 1,
		'description'           => '',
	]
);
