<?php
/**
 * Show Gutenberg sidebar
 *
 * @package nisje
 */

namespace Nisje\Extensions\GutenbergShowSidebar;

/**
 * Add editor assets
 */
function editor_assets(): void {
	$asset_file = NISJE_CORE_DIR_PATH . 'extensions/gutenberg-show-sidebar/build/index.asset.php';

	if ( ! \file_exists( $asset_file ) ) {
		return;
	}

	$asset        = require_once $asset_file;
	$dependencies = isset( $asset['dependencies'] ) ? $asset['dependencies'] : [];
	$version      = isset( $asset['version'] ) ? $asset['version'] : filemtime( $path );

	\wp_enqueue_script(
		'nisje-extension-gutenberg-show-sidebar',
		NISJE_CORE_URL . 'extensions/gutenberg-show-sidebar/build/index.js',
		$dependencies,
		$version,
		true
	);
}
\add_action( 'enqueue_block_editor_assets', __NAMESPACE__ . '\\editor_assets' );
