<?php
/**
 * Wiki Comments
 *
 * @package nisje
 */

namespace Nisje\Extensions\WikiComments;

/**
 * Add comments to the wiki post type.
 *
 * @param array $settings Post type settings.
 */
function add_comments_support( array $settings ): array {
	$settings['supports'][] = 'comments';
	return $settings;
}
\add_filter( 'nisje_wiki_post_type_args', __NAMESPACE__ . '\\add_comments_support' );

/**
 * Add comments to the wiki post type.
 */
\add_filter( 'nisje_frontend_options', function( $options ) {
	$options['wikiComments'] = true;
	return $options;
}, 20 );
