<?php
/**
 * Wiki graphql
 *
 * @package Nisje
 */

namespace Nisje\Extension\Wiki\GraphQL;

use const Nisje\Extension\Wiki\TAXONOMY_NAME;
use function Nisje\Utils\get_term_post_count;

/**
 * Extend WPGraphQL schema
 */
function extend_wpgraphql_schema() {
	\register_graphql_field( 'wikiCategory', 'padCount', [
		'type'    => 'number',
		'resolve' => function( $source ) {
			return get_term_post_count( TAXONOMY_NAME, $source->termTaxonomyId ); // phpcs:ignore
		},
	] );
}
\add_action( 'graphql_register_types', __NAMESPACE__ . '\\extend_wpgraphql_schema' );
