<?php
/**
 * Extend Members Endpoint with Profile Fields
 *
 * @package Nisje
 */

defined( 'ABSPATH' ) || die( 'Shame on you' );

register_rest_field( 'user', 'profile_layouts', [
	'get_callback' => function( $object ) {
		$retval = [];

		$retval = nisje_get_user_profile_layouts( $object['id'] );

		return $retval;
	},
	'schema'       => [
		'context'     => [ 'view', 'edit' ],
		'description' => esc_html__( 'Collection of profile fields', 'nisje' ),
		'type'        => 'array',
		'items'       => [
			'type' => 'object',
		],
		'readonly'    => true,
	],
] );
