<?php
/**
 * Wiki Group Rest API.
 *
 * @package Nisje
 */

declare( strict_types = 1 );
namespace Nisje\Extension\Wiki\Groups\Rest;

use const Nisje\Extension\Wiki\Groups\{
	GROUP_META_KEY,
	POST_TYPE_REST
};

/**
 * Register REST API endpoints.
 */
function register_rest_routes() {
	// Extend BuddyPress Groups REST API.
	\register_rest_field( 'bp_groups', 'enable_wiki', [
		'get_callback' => function( $object ) {
			return (bool) \groups_get_groupmeta( $object['id'], GROUP_META_KEY, true );
		},
		'schema'       => [
			'context'     => [ 'view', 'edit' ],
			'description' => 'Is group wiki enabled',
			'type'        => 'bool',
			'readonly'    => true,
		],
	] );
}
\add_action( 'rest_api_init', __NAMESPACE__ . '\\register_rest_routes' );

/**
 * Extend rest types.
 *
 * @param array $post_types Current Post Types.
 * @return array $post_types Populated Post Types.
 */
function add_shared_rest_fields( array $post_types ): array {
	$post_types[] = POST_TYPE_REST;
	return $post_types;
}
\add_filter( 'nisje_rest_shared_fields_group_post_types', __NAMESPACE__ . '\\add_shared_rest_fields' );
