<?php
/**
 * Wiki Group settings.
 *
 * @package Nisje
 */

declare( strict_types = 1 );
namespace Nisje\Extension\Wiki\Groups;

use function Nisje\Extension\Wiki\Utils\get_title;
use const Nisje\Constants\GROUP_POST_CAP;

/**
 * Add group features
 *
 * @param array $features Features.
 */
function add_group_feature( array $features ): array {
	$features['enable_wiki'] = [
		'label'       => get_title(),
		'description' => \__( 'Enable articles', 'nisje' ),
	];

	return $features;
}
\add_filter( 'nisje_group_features', __NAMESPACE__ . '\\add_group_feature', 50 );

/**
 * Add settings
 *
 * @param array $settings Settings.
 */
function add_settings( array $settings ): array {
	if ( \is_user_logged_in() ) {
		$user_id = \get_current_user_id();
		$user    = \get_userdata( $user_id );

		$settings['userCapabilities']['edit']['groupWiki']   = $user->allcaps[ 'edit_' . GROUP_POST_CAP ] ?? false;
		$settings['userCapabilities']['create']['groupWiki'] = $user->allcaps[ 'create_' . GROUP_POST_CAP . 's' ] ?? false;
	}

	return $settings;
}
\add_filter( 'nisje_frontend_options', __NAMESPACE__ . '\\add_settings' );
