/**
 * WordPress dependencies
 */
import domReady from '@wordpress/dom-ready';
import { select, dispatch } from '@wordpress/data';

domReady(() => {
	if (
		select('core/interface').getActiveComplementaryArea(
			'core/edit-post',
		) !== ('edit-post/document' || 'edit-post/block') &&
		select('core/viewport').isViewportMatch('>= large')
	) {
		dispatch('core/interface').enableComplementaryArea(
			'core/edit-post',
			'edit-post/document',
		);
	}
});
